package fr.asip.cps3.exemple.vues.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser la bote de dialogue de saisie d'un code
 */
public class SaisieCode  {

	JFrame fenetre;
	protected String titre;
	protected JDialog d;
	protected JLabel libellePIN;
	protected JLabel libelleConformite;	
	protected JPasswordField codePorteur;
	protected JPanel panel;
	protected JButton btnValider;
	protected JButton btnAnnuler;
	protected int choixUtilisateur;
	protected char[] code = null; 
	
	/**
	 * Constructeur
	 * @param fenetre fentre parente de la dialog
	 * @param titre titre de la dialog
	 * @param numeroSerieCarte Numro de srie de la carte
	 */
	public SaisieCode(JFrame fenetre, String titre, String conformiteCode, String numeroSerieCarte) {
		
		this.fenetre = fenetre;
		this.titre = titre;
		d = new JDialog(fenetre);
		libellePIN = new JLabel("Veuillez entrer le code porteur de la carte "+numeroSerieCarte+": ");
		if(conformiteCode != null) {
			libelleConformite = new JLabel(conformiteCode);
			libelleConformite.setForeground(Color.BLACK);
			libelleConformite.setFont(new Font("Arial",Font.BOLD,11));
		}
		codePorteur = new JPasswordField(32);
		btnValider = new JButton("Valider");
		btnAnnuler = new JButton("Annuler");
		
	}

	/**
	 * Affiche la dialog
	 */
	public void affiche() {
		
		panel = new JPanel();
		
		// Cration du layout
		panel.setBorder(new EmptyBorder(0, 0, 0, 0));
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        
        // Ajout des composants
        GridBagHelper g = new GridBagHelper(panel);
        
        int i = 0;
        if(libelleConformite != null) {
        	g.ajoute(libelleConformite, EcranUtil.styleLibelleDialogLigneEntiere, 0, 0, 1, 2);
        	i++;
        }
        g.ajoute(libellePIN, EcranUtil.styleLibelleDialogLigneEntiere, i+0, 0, 1, 2);
        g.ajoute(codePorteur, EcranUtil.styleTexteDialog, i+1, 0, 1, 2);
        g.ajoute(btnValider, EcranUtil.styleBoutonDialogValider, i+2, 0, 1, 1);
        g.ajoute(btnAnnuler, EcranUtil.styleBoutonDialogAnnuler, i+2, 1, 1, 1);

		d.getContentPane().add(panel,BorderLayout.CENTER);
		d.setTitle(titre);
		d.setModal(true);
		d.pack();
		
		// centrage de la dialog
        Rectangle r = fenetre.getBounds();
        int x = r.x + (r.width - d.getSize().width)/2;
        int y = r.y + (r.height - d.getSize().height)/2;
        d.setLocation(x, y);
		
		ActionListener ecouteur = new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if(ae.getSource() == btnAnnuler) {
					choixUtilisateur = -1;
				} else {
					code = codePorteur.getPassword();
					choixUtilisateur = 1;
				}
				d.dispose();
			}
		};

		btnValider.addActionListener(ecouteur);
		btnAnnuler.addActionListener(ecouteur);
		
		d.setVisible(true);		
				
		
	}
	
	/**
	 * Accesseur
	 * @return Code porteur
	 */
	public char[] getCode(){
		return code;
	}

	/**
	 * Accesseur
	 * @return Choix utilisateur
	 */
	public int getChoixUtilisateur(){
		return choixUtilisateur;
	}	
	
}